﻿uses
  Common, DataEntry, DataStorage, DateUtils, RegEx, SysUtils;

function FilterEntry(anEntry: TEntry; InObj: TObject): integer;
var
  aSignature: TFileTypeInformation;

begin
  Result := -1; // Exclude

  if assigned(anEntry) then
  begin
    aSignature := anEntry.FileDriverInfo;

    if anEntry.isFreeSpace then
      Exit;

    if dtGraphics in aSignature.DriverType then
    begin
      if RegexMatch(anEntry.EntryName, 'bird|cat|chicken|croc|dog|face|fish|sheep|snake|squirrel', False) then
      begin
        Result := 1; // Include
        if Result = 1 then
        begin
          if anEntry.Extension = '' then
            Result := -1; // Exclude
        end;
      end;
    end;

    // Include by determined signature only - must run a file signature analysis first
    if Result = -1 then
    begin
      aSignature := anEntry.FileDriverInfo;
      if (aSignature.ShortDisplayName = 'DocX') or // noslz
        (aSignature.ShortDisplayName = 'XLSX') or // noslz
        (aSignature.ShortDisplayName = 'Excel') or // noslz
        (aSignature.ShortDisplayName = 'Word') then // noslz
        Result := 1; // Include
    end;

    if Result = -1 then
    begin
      if dtVideo in aSignature.DriverType then
      begin
        Result := 1; // Include
      end;
    end;

  end;
end;

function ScriptInformation: TScriptInformation;
begin
  Result.Name := 'filter_final_practical.pas';
  Result.Modules := [modFILESYSTEM];
end;

begin

end.
